/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NBTTags;
import noppes.npcs.Server;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.config.ConfigLoader;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumSync;
import noppes.npcs.controllers.AnimationController;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.BorderController;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.KeyController;
import noppes.npcs.controllers.MarcetController;
import noppes.npcs.controllers.PlayerQuestController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.TransportController;
import noppes.npcs.controllers.data.Bank;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DialogCategory;
import noppes.npcs.controllers.data.Faction;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.controllers.data.QuestCategory;
import noppes.npcs.items.ItemScripted;
import noppes.npcs.util.BuilderData;

public class SyncController {
    public static final Map<Integer, BuilderData> dataBuilder = new HashMap<Integer, BuilderData>();

    public static void add(EnumSync synctype, NBTTagCompound compound, boolean syncEnd, EntityPlayer player) {
        switch (synctype) {
            case FactionsData: {
                Object faction;
                NBTTagList list = compound.func_150295_c("Data", 10);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    faction = new Faction();
                    ((Faction)faction).load(list.func_150305_b(i));
                    FactionController.instance.factionsSync.put(((Faction)faction).id, (Faction)faction);
                }
                if (!syncEnd) break;
                FactionController fData = FactionController.instance;
                fData.factions.clear();
                faction = fData.factionsSync.keySet().iterator();
                while (faction.hasNext()) {
                    int id = (Integer)faction.next();
                    fData.factions.put(id, fData.factionsSync.get(id));
                }
                fData.factionsSync.clear();
                break;
            }
            case QuestCategoriesData: {
                if (!compound.func_150296_c().isEmpty()) {
                    QuestCategory category = QuestController.instance.categoriesSync.containsKey(compound.func_74762_e("Slot")) ? QuestController.instance.categoriesSync.get(compound.func_74762_e("Slot")) : new QuestCategory();
                    category.load(compound);
                    QuestController.instance.categoriesSync.put(category.id, category);
                }
                if (!syncEnd) break;
                QuestController qData = QuestController.instance;
                TreeMap<Integer, Quest> quests = new TreeMap<Integer, Quest>();
                for (QuestCategory category : qData.categoriesSync.values()) {
                    for (Quest quest : category.quests.values()) {
                        quests.put(quest.id, quest);
                    }
                }
                qData.categories.clear();
                qData.categories.putAll(qData.categoriesSync);
                qData.quests.clear();
                qData.quests.putAll(quests);
                qData.categoriesSync.clear();
                break;
            }
            case DialogCategoriesData: {
                if (!compound.func_150296_c().isEmpty()) {
                    DialogCategory category = DialogController.instance.categoriesSync.containsKey(compound.func_74762_e("Slot")) ? DialogController.instance.categoriesSync.get(compound.func_74762_e("Slot")) : new DialogCategory();
                    category.load(compound);
                    DialogController.instance.categoriesSync.put(category.id, category);
                }
                if (!syncEnd) break;
                DialogController dData = DialogController.instance;
                TreeMap<Integer, Dialog> dialogs = new TreeMap<Integer, Dialog>();
                for (DialogCategory category4 : dData.categoriesSync.values()) {
                    for (Dialog dialog : category4.dialogs.values()) {
                        dialogs.put(dialog.id, dialog);
                    }
                }
                dData.categories.clear();
                dData.categories.putAll(dData.categoriesSync);
                dData.dialogs.clear();
                dData.dialogs.putAll(dialogs);
                dData.categoriesSync.clear();
                break;
            }
            case DialogGuiSettings: {
                DialogController.instance.getGuiSettings().load(compound);
                break;
            }
            case ModData: {
                if (!syncEnd) {
                    return;
                }
                ConfigLoader.load(compound);
                break;
            }
            case KeysData: {
                KeyController.getInstance().loadKeys(compound);
                CustomNpcs.proxy.updateKeys();
                break;
            }
            case TransportData: {
                TransportController.getInstance().loadCategories(compound);
                break;
            }
            case Debug: {
                List<String> list = CustomNpcs.debugData.logging();
                for (String str : list) {
                    player.func_145747_a((ITextComponent)new TextComponentString(str));
                }
                try {
                    Class<?> nirn = Class.forName("nirn.betazavr.Nirn");
                    Object nirnMod = nirn.getField("instance").get(null);
                    List nirnList = (List)nirn.getMethod("showDebugs", new Class[0]).invoke(nirnMod, new Object[0]);
                    for (String str : nirnList) {
                        player.func_145747_a((ITextComponent)new TextComponentString(str));
                    }
                    break;
                }
                catch (Exception exception) {
                    break;
                }
            }
        }
    }

    public static void remove(EnumSync synctype, int id, ByteBuf buffer) {
        switch (synctype) {
            case FactionsData: {
                FactionController.instance.factions.remove(id);
                break;
            }
            case QuestData: {
                Quest quest = QuestController.instance.quests.remove(id);
                if (quest == null) break;
                quest.category.quests.remove(id);
                break;
            }
            case QuestCategoriesData: {
                QuestCategory category = QuestController.instance.categories.remove(id);
                if (category == null) break;
                QuestController.instance.quests.keySet().removeAll(category.quests.keySet());
                break;
            }
            case DialogData: {
                Dialog dialog = DialogController.instance.dialogs.remove(id);
                if (dialog == null) break;
                dialog.category.dialogs.remove(id);
                break;
            }
            case DialogCategoriesData: {
                DialogCategory category = DialogController.instance.categories.remove(id);
                if (category == null) break;
                DialogController.instance.dialogs.keySet().removeAll(category.dialogs.keySet());
                break;
            }
            case RecipesData: {
                RecipeController.getInstance().delete(id);
                break;
            }
            case KeysData: {
                KeyController.getInstance().removeKeySetting(id);
                CustomNpcs.proxy.updateKeys();
                break;
            }
            case MarcetData: {
                MarcetController.getInstance().markets.remove(id);
                break;
            }
            case MarcetDeal: {
                MarcetController.getInstance().deals.remove(id);
                break;
            }
            case BankData: {
                BankController.getInstance().banks.remove(id);
                break;
            }
            case BankCeil: {
                Bank bank = BankController.getInstance().banks.get(buffer.readInt());
                if (bank == null) break;
                bank.removeCeil(id);
                break;
            }
            case Debug: {
                CustomNpcs.debugData.clear();
                break;
            }
        }
    }

    public static void update(EnumSync synctype, NBTTagCompound compound, ByteBuf buffer, EntityPlayer player) {
        switch (synctype) {
            case FactionsData: {
                Faction faction = new Faction();
                faction.load(compound);
                FactionController.instance.factions.put(faction.id, faction);
                break;
            }
            case QuestData: {
                int id = compound.func_74762_e("Id");
                if (QuestController.instance.quests.containsKey(id)) {
                    Quest quest = QuestController.instance.quests.get(id);
                    quest.load(compound);
                } else {
                    QuestCategory category = QuestController.instance.categories.get(buffer.readInt());
                    Quest quest = new Quest(category);
                    quest.load(compound);
                    QuestController.instance.quests.put(quest.id, quest);
                    category.quests.put(quest.id, quest);
                }
                for (Quest q : PlayerQuestController.getActiveQuests(player)) {
                    if (q.id != id) continue;
                    q.load(compound);
                }
                break;
            }
            case QuestCategoriesData: {
                QuestCategory category = new QuestCategory();
                category.load(compound);
                QuestController.instance.categories.put(category.id, category);
                break;
            }
            case DialogData: {
                if (DialogController.instance.dialogs.containsKey(compound.func_74762_e("DialogId"))) {
                    Dialog dialog = DialogController.instance.dialogs.get(compound.func_74762_e("DialogId"));
                    dialog.load(compound);
                    break;
                }
                DialogCategory category = DialogController.instance.categories.get(buffer.readInt());
                Dialog dialog = new Dialog(category);
                dialog.load(compound);
                DialogController.instance.dialogs.put(dialog.id, dialog);
                category.dialogs.put(dialog.id, dialog);
                break;
            }
            case DialogCategoriesData: {
                DialogCategory category = new DialogCategory();
                category.load(compound);
                DialogController.instance.categories.put(category.id, category);
                break;
            }
            case DialogGuiSettings: {
                DialogController.instance.getGuiSettings().load(compound);
                break;
            }
            case RecipesData: {
                if (compound.func_150296_c().isEmpty()) {
                    if (CustomNpcs.Server != null && CustomNpcs.Server.func_71264_H()) {
                        return;
                    }
                    RecipeController.getInstance().clear();
                    break;
                }
                RecipeController.getInstance().loadNBTRecipe(compound);
                break;
            }
            case AnimationData: {
                if (compound.func_150296_c().isEmpty()) {
                    if (CustomNpcs.Server != null && CustomNpcs.Server.func_71264_H()) {
                        return;
                    }
                    AnimationController.getInstance().animations.clear();
                    AnimationController.getInstance().emotions.clear();
                    break;
                }
                if (compound.func_150297_b("delete", 1) && compound.func_74767_n("delete")) {
                    AnimationController.getInstance().removeAnimation(compound.func_74762_e("ID"));
                    break;
                }
                AnimationController.getInstance().loadAnimation(compound);
                break;
            }
            case EmotionData: {
                if (compound.func_150296_c().isEmpty()) {
                    if (CustomNpcs.Server != null && CustomNpcs.Server.func_71264_H()) {
                        return;
                    }
                    AnimationController.getInstance().emotions.clear();
                    break;
                }
                if (compound.func_150297_b("delete", 1) && compound.func_74767_n("delete")) {
                    AnimationController.getInstance().removeEmotion(compound.func_74762_e("ID"));
                    break;
                }
                AnimationController.getInstance().loadEmotion(compound);
                break;
            }
            case PlayerGameData: {
                ClientProxy.playerData.game.readFromNBT(compound);
                CustomNpcs.proxy.updateGUI();
                break;
            }
            case PlayerQuestData: {
                ClientProxy.playerData.questData.loadNBTData(compound);
                CustomNpcs.proxy.updateGUI();
                break;
            }
            case KeysData: {
                KeyController.getInstance().loadKey(compound);
                CustomNpcs.proxy.updateKeys();
                break;
            }
            case BankData: {
                Bank bank = BankController.getInstance().getBank(compound.func_74762_e("BankID"));
                if (bank != null) {
                    bank.readFromNBT(compound);
                    break;
                }
                bank = new Bank();
                bank.readFromNBT(compound);
                BankController.getInstance().banks.put(bank.id, bank);
                break;
            }
            case GameData: {
                PlayerData data = PlayerData.get(player);
                if (data == null) break;
                data.game.readFromNBT(compound);
                break;
            }
            case MailData: {
                int[] vs;
                PlayerData data;
                if (compound.func_150297_b("MailData", 9) && (data = PlayerData.get(player)) != null) {
                    data.mailData.loadNBTData(compound);
                }
                if (compound.func_150297_b("LettersBeDeleted", 3)) {
                    CustomNpcs.MailTimeWhenLettersWillBeDeleted = compound.func_74762_e("LettersBeDeleted");
                }
                if (compound.func_150297_b("LettersBeReceived", 11)) {
                    vs = compound.func_74759_k("LettersBeReceived");
                    System.arraycopy(vs, 0, CustomNpcs.MailTimeWhenLettersWillBeReceived, 0, vs.length);
                }
                if (compound.func_150297_b("CostSendingLetter", 11)) {
                    vs = compound.func_74759_k("CostSendingLetter");
                    System.arraycopy(vs, 0, CustomNpcs.MailCostSendingLetter, 0, vs.length);
                }
                if (!compound.func_150297_b("SendToYourself", 1)) break;
                CustomNpcs.MailSendToYourself = compound.func_74767_n("SendToYourself");
                break;
            }
            case BuilderData: {
                BuilderData builder = dataBuilder.containsKey(compound.func_74762_e("ID")) ? dataBuilder.get(compound.func_74762_e("ID")) : new BuilderData(compound.func_74762_e("ID"), compound.func_74762_e("BuilderType"));
                builder.read(compound);
                break;
            }
            case Debug: {
                CustomNpcs.VerboseDebug = compound.func_74767_n("debug");
                break;
            }
        }
    }

    public static void syncAllDialogs(MinecraftServer server) {
        for (DialogCategory category : DialogController.instance.categories.values()) {
            Server.sendToAll(server, EnumPacketClient.SYNC_ADD, new Object[]{EnumSync.DialogCategoriesData, category.save(new NBTTagCompound())});
        }
        Server.sendToAll(server, EnumPacketClient.SYNC_END, new Object[]{EnumSync.DialogCategoriesData, new NBTTagCompound()});
        Server.sendToAll(server, EnumPacketClient.SYNC_UPDATE, new Object[]{EnumSync.DialogGuiSettings, DialogController.instance.getGuiSettings().save()});
    }

    public static void syncAllQuests(MinecraftServer server) {
        for (QuestCategory category : QuestController.instance.categories.values()) {
            Server.sendToAll(server, EnumPacketClient.SYNC_ADD, new Object[]{EnumSync.QuestCategoriesData, category.save(new NBTTagCompound())});
        }
        Server.sendToAll(server, EnumPacketClient.SYNC_END, new Object[]{EnumSync.QuestCategoriesData, new NBTTagCompound()});
    }

    public static void syncPlayer(EntityPlayerMP player) {
        NBTTagCompound compound;
        CustomNpcs.debugData.start(player);
        NBTTagList list = new NBTTagList();
        for (Faction faction : FactionController.instance.factions.values()) {
            list.func_74742_a((NBTBase)faction.save(new NBTTagCompound()));
            if (list.func_74745_c() <= 20) continue;
            compound = new NBTTagCompound();
            compound.func_74782_a("Data", (NBTBase)list);
            Server.sendData(player, EnumPacketClient.SYNC_ADD, new Object[]{EnumSync.FactionsData, compound});
            list = new NBTTagList();
        }
        compound = new NBTTagCompound();
        compound.func_74782_a("Data", (NBTBase)list);
        Server.sendData(player, EnumPacketClient.SYNC_END, new Object[]{EnumSync.FactionsData, compound});
        for (QuestCategory questCategory : QuestController.instance.categories.values()) {
            Server.sendData(player, EnumPacketClient.SYNC_ADD, new Object[]{EnumSync.QuestCategoriesData, questCategory.save(new NBTTagCompound())});
        }
        Server.sendData(player, EnumPacketClient.SYNC_END, new Object[]{EnumSync.QuestCategoriesData, new NBTTagCompound()});
        for (DialogCategory dialogCategory : DialogController.instance.categories.values()) {
            Server.sendData(player, EnumPacketClient.SYNC_ADD, new Object[]{EnumSync.DialogCategoriesData, dialogCategory.save(new NBTTagCompound())});
        }
        Server.sendData(player, EnumPacketClient.SYNC_END, new Object[]{EnumSync.DialogCategoriesData, new NBTTagCompound()});
        Server.sendData(player, EnumPacketClient.SYNC_END, new Object[]{EnumSync.DialogGuiSettings, DialogController.instance.getGuiSettings().save()});
        AnimationController.getInstance().sendTo(player);
        ConfigLoader.sendTo(player);
        PlayerData data = PlayerData.get((EntityPlayer)player);
        if (player.func_184102_h() != null) {
            data.game.op = player.func_184102_h().func_184103_al().func_152596_g(player.func_146103_bH());
        }
        compound = data.getNBT();
        Server.sendData(player, EnumPacketClient.SYNC_END, new Object[]{EnumSync.PlayerData, compound});
        Server.sendData(player, EnumPacketClient.SYNC_END, new Object[]{EnumSync.KeysData, KeyController.getInstance().getNBT()});
        SyncController.syncScriptItems(player);
        SyncController.syncScriptRecipes(player);
        BorderController.getInstance().sendTo(player);
        MarcetController.getInstance().sendTo(player, -1);
        ScriptController.Instance.sendClientTo(player);
        CustomNpcs.debugData.end(player);
    }

    private static void syncScriptRecipes(EntityPlayerMP player) {
        RecipeController.getInstance().sendTo(player);
        player.func_192021_a(RecipeController.getInstance().getKnownRecipes());
    }

    public static void syncScriptItems(EntityPlayerMP player) {
        NBTTagCompound comp = new NBTTagCompound();
        comp.func_74782_a("List", (NBTBase)NBTTags.nbtIntegerStringMap(ItemScripted.Resources));
        Server.sendData(player, EnumPacketClient.SYNC_END, new Object[]{EnumSync.ItemScriptedModels, comp});
    }

    public static void syncScriptItemsEverybody() {
        NBTTagCompound comp = new NBTTagCompound();
        comp.func_74782_a("List", (NBTBase)NBTTags.nbtIntegerStringMap(ItemScripted.Resources));
        for (EntityPlayerMP player : CustomNpcs.Server.func_184103_al().func_181057_v()) {
            Server.sendData(player, EnumPacketClient.SYNC_END, new Object[]{EnumSync.ItemScriptedModels, comp});
        }
    }
}

